unit Unit1;
{==============================================================================}
{ This demo shows how to add text in RichView at run-time.                     }
{ See comments in TForm1.FormCreate                                            }
{==============================================================================}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RVScroll, RichView, RVStyle;

type
  TForm1 = class(TForm)
    RVStyle1: TRVStyle;
    RichView1: TRichView;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  // Clear deletes all items of RichView.
  // There are no items at the beginning, so this call of Clear is
  // just for demonstration.
  RichView1.Clear;

  // Adding the first paragraph.
  // This paragraph has the 1-th style (centered by default; you can view/modify
  // it in RVStyle1.ParaStyles property).
  // This paragraph consists of one item of the 1-th text style
  RichView1.AddNL('Adding Text', 1, 1);

  // Adding the second paragraph.
  // This paragraph has the 0-th style (style is defined by the first item in paragraph).
  RichView1.AddNL('This demo shows how to add text in ', 0, 0);
  // Continuing the second paragraph.
  // Note: -1 is passed as an index of paragraph style.
  // This means that this item will be added to the last paragraph.
  RichView1.AddNL('RichView', 3, -1);
  // Continuing the second paragraph...
  RichView1.AddNL('. There are two paragraphs in this document - '+
                  'the first one with centered alignment, and the second one - '+
                  'with left alignment. The first paragraph consists of one text item, '+
                  'and the second paragraph consists of three items. '+
                  'Each item is added with one call of AddNL method.', 0, -1);
  // But text will not be displayed yet. You need to call Format method after adding
  // all contents to RichView:
  RichView1.Format;
end;

end.
